/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.php.indexer;

import com.aptana.core.logging.IdeLog;
import com.aptana.editor.php.PHPEditorPlugin;
import com.aptana.editor.php.indexer.IIndexingASTVisitor;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;

public final class ASTVisitorRegistry {
    private static final String EXTENSION_POINT_NAME = "com.aptana.editor.php.astVisitor";
    private static ASTVisitorRegistry instance;
    private List<IIndexingASTVisitor> visitors;

    private ASTVisitorRegistry() {
        IConfigurationElement[] configurationElementsFor = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT_NAME);
        this.visitors = new ArrayList<IIndexingASTVisitor>();
        IConfigurationElement[] iConfigurationElementArray = configurationElementsFor;
        int n = configurationElementsFor.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement e = iConfigurationElementArray[n2];
            try {
                IIndexingASTVisitor createExecutableExtension = (IIndexingASTVisitor)e.createExecutableExtension("class");
                this.visitors.add(createExecutableExtension);
            }
            catch (CoreException e1) {
                IdeLog.logError((Plugin)PHPEditorPlugin.getDefault(), (String)"Error loading a PHP indexing AST visitor extension", (Throwable)e1);
            }
            ++n2;
        }
    }

    public static ASTVisitorRegistry getInstance() {
        if (instance == null) {
            instance = new ASTVisitorRegistry();
        }
        return instance;
    }

    public IIndexingASTVisitor[] getVisitors() {
        return this.visitors.toArray(new IIndexingASTVisitor[this.visitors.size()]);
    }
}

